#include "nxp_lpc43xx.h"

void SCT_Init(void)
{
    LPC_SCT->CONFIG        |= (1 << 0) | (1 << 17);        // unified 32-bit timer, auto limit

    LPC_SCT->MATCHREL[0].U  = (SystemCoreClock/100)-1;

    LPC_SCT->EVENT[0].STATE = 0x00000001;                  // event 0 only happens in state 0
    LPC_SCT->EVENT[0].CTRL  = (0 << 0)  |                  // MATCHSEL[3:0]   = related to match 0
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (0 << 14) |                  // STATELD [14]    = STATEV is added to state
                              (0 << 15);                   // STATEV  [15]    = no state change

    LPC_SCT->EVEN           = (1 << 0);                    // event 0 generates an interrupt
    NVIC_EnableIRQ(SCT_IRQn);                              // enable SCT interrupt

    LPC_SCT->CTRL_U        &= ~(1 << 2);                   // unhalt it by clearing bit 2 of the CTRL register
}
